
from ctypes import *
import sys
import time

class spiController_v2:
    def __init__(self, mosi_pin, miso_pin, clk_pin, ss_pin):
        # Pin Settings
        self.clk_pin = clk_pin #which digital out pin is used for the clk (DIO#)
        self.mosi_pin = mosi_pin #which pin is used for data out (mosi)
        self.miso_pin = miso_pin #which pin is used for data in (miso)
        self.ss_pin = ss_pin

        # Clock Settings
        self.spi_freq = 50000#25000 #slow program 10000
        #self.spi_freq = 100000 #305000 #bit rate of spi, 650
        self.spi_clk_mode = 0b00 # first bit is CPOL, second bit is CPHA

        # Data Settings
        self.spi_transfer_mode = 1 # 1 = MOSI for Write, MISO for read
        self.bit_direction = 1 # 0 is LSB, 1 is MSB
        self.word_size = 8 # 8 bit words

        # SS Settings
        self.ss_active_high = False #polarity of slave select, true if enabled on high, false if enabled on low
        if (self.ss_active_high):
            self.ss_enable = c_int(1)
            self.ss_disable = c_int(0)
        else:
            self.ss_enable = c_int(0)
            self.ss_disable = c_int(1)

        self.connect()

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, tb):
        print "Closing SPI..."
        # disable ss to finish the packet if interupted
        self.dwf.FDwfDigitalSpiSelect(self.hdwf, c_int(self.ss_pin), self.ss_disable)## disable ss
        self.disconnect()

    def __del__(self):
        print "Closing SPI..."
        # disable ss to finish the packet if interupted
        self.dwf.FDwfDigitalSpiSelect(self.hdwf, c_int(self.ss_pin), self.ss_disable)## disable ss
        self.disconnect()

    def connect(self):
        self.dwf = cdll.LoadLibrary("C:\Windows\System32\dwf.dll")
        self.hdwf = c_int()

        print "Opening SPI..."

        self.dwf.FDwfDeviceOpen(c_int(-1), byref(self.hdwf))

        if self.hdwf.value == 0:
            print("FAILED TO OPEN DEVICE")
            szerr = create_string_buffer(512)
            self.dwf.FDwfGetLastErrorMsg(szerr)
            print(str(szerr.value))
            quit()
        print "Spi Opened"

        print "Configuring SPI..."
        self.dwf.FDwfDigitalSpiFrequencySet(self.hdwf, c_double(self.spi_freq))
        self.dwf.FDwfDigitalSpiClockSet(self.hdwf, c_int(self.clk_pin))
        self.dwf.FDwfDigitalSpiDataSet(self.hdwf, c_int(0), c_int(self.mosi_pin)) # configure MOSI
        self.dwf.FDwfDigitalSpiDataSet(self.hdwf, c_int(1), c_int(self.miso_pin)) # configure MISO
        self.dwf.FDwfDigitalSpiModeSet(self.hdwf, c_int(self.spi_clk_mode)) # configure spi_mode
        self.dwf.FDwfDigitalSpiOrderSet(self.hdwf, c_int(self.bit_direction)) # configure MSB/LSB first

        # start driving the channels, clock and data
        self.dwf.FDwfDigitalSpiWriteOne(self.hdwf, c_int(self.spi_transfer_mode), c_int(0), c_int(0))
        time.sleep(0.4)
        print "Spi Ready"

    def disconnect(self):
        # close devices
        self.dwf.FDwfDeviceCloseAll()

    #data should be a list of byte information
    def sendData(self, data, verbose = False):
        dataTX = (c_ubyte*len(data))(c_uint8(2))
        for i in range(len(data)):
            byteValue = int(data[i])
            dataTX[i] = c_uint8(byteValue)
        ss_c =c_int(self.ss_pin)
        tm_c = c_int(self.spi_transfer_mode)
        ws_c = c_int(self.word_size)
        len_tx_c = c_int(len(dataTX))
        self.dwf.FDwfDigitalSpiSelect(self.hdwf, ss_c, self.ss_enable) ## enable ss
        self.dwf.FDwfDigitalSpiWrite(self.hdwf, tm_c, ws_c, dataTX, len_tx_c) # write array of 8 bit (byte) length elements
        self.dwf.FDwfDigitalSpiSelect(self.hdwf, ss_c, self.ss_disable)## disable ss
        if verbose:
            print "Transfered Over SPI:", dataTX[0:len(dataTX)]
